/*
 * *
 *  * @(#)UserLoginInterceptor.java 2.0.0 18-9-20 上午9:36
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.cube.center.identity.interceptor;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.constants.AuthConstants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

/**
 * 认证拦截器，判断用户是否已经成功登陆
 * 
 * @author luo.lei
 */
public class UserLoginInterceptor extends HandlerInterceptorAdapter {

	private static final Logger logger = LoggerFactory.getLogger(UserLoginInterceptor.class);

	/**
	 * 未登录返回的json数据
	 */
	private String respResult = "{\"resultCode\":401,\"resultMsg\":\"no login\"}";

	public final ITokenApi tokenApi;

	public UserLoginInterceptor(ITokenApi tokenApi) {
		this.tokenApi = tokenApi;
	}

	@Override
	public boolean preHandle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object handler)
			throws Exception {
		boolean isContinue = false;

		String auth = httpRequest.getHeader(AuthConstants.ACCESS_TOKEN);

		if (StringUtils.isNotBlank(auth) && checkToken(auth)) {
			isContinue = true;
		} else {
			notLoginResponse(httpResponse);
		}

		return isContinue;
	}

	private boolean checkToken(String token) {
		try {
			RestResponse<Map<String, Object>> restResponse = tokenApi.checkToken(token);
			if ("0".equals(restResponse.getResultCode())) {
				return true;
			}
		} catch (Exception e) {
			logger.error("校验token出错 : {} 。该错误被忽略", e.getMessage());
		}
		return false;
	}

	private void notLoginResponse(HttpServletResponse httpResponse) throws IOException {
		httpResponse.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
		PrintWriter out = httpResponse.getWriter();
		out.append(respResult);
		out.close();
	}

}
