/**
 * @(#) IAppSecretApi.java 1.0 2019-01-21
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AppSecretReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author 刘 备
 * @since 1.0.0
 */

@Api(tags = {"认证中心：第三方渠道配置"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-IAppSecretApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2/app-secret", url = "${yundt.cube.center.identity.api:}")
public interface IAppSecretApi {

    /**
     * 创建第三方渠道配置
     *
     * @param appSecretReqDto
     * @return
     */
    @RequestMapping(method = RequestMethod.POST)
    @ApiOperation(value = "新增第三方渠道配置", notes = "新增第三方渠道配置,目前支持微信,QQ,新浪,钉钉,Facebook的第三方渠道配置,配置后通过调用第三方绑定相关接")
    RestResponse<Long> create(@RequestBody AppSecretReqDto appSecretReqDto);

    /**
     * 删除第三方渠道配置
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除第三方渠道配置", notes = "删除第三方渠道配置")
    RestResponse<Void> delete(@PathVariable("id") Long id);


    /**
     * 修改第三方渠道配置
     *
     * @param id
     * @param appSecretReqDto
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.PUT)
    @ApiOperation(value = "修改第三方渠道配置", notes = "修改第三方渠道配置")
    RestResponse<Void> modify(@PathVariable("id") Long id, @RequestBody AppSecretReqDto appSecretReqDto);

}