/**
 * @(#) IUserLoginConfigApi.java 1.0 2018-08-31
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 用户登录配置信息Api
 *
 * @author 项羽
 * @since 2.0.0
 */
@Api(tags = { "认证中心：用户登录配置信息" })
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-IUserLoginConfigApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2/user", url = "${yundt.cube.center.identity.api:}")
public interface IUserLoginConfigApi {

	/**
	 * 新增用户登录配置
	 *
	 * @param userId 用户id
	 * @param configItem
	 *            用户登录配置信息请求实体
	 * @return String 保存成功后返回值
	 */
	@PostMapping(value = "/{userId}/loginconfig", produces = "application/json")
	@ApiOperation(value = "用户登录配置新增", notes = "认证中心新增保存用户登录配置信息userId标志用户，configItem表示登录配置内容用户登录配置"
			+ "1用户名username+密码；2手机+密码；3手机+验证码；4身份证+密码；5邮箱+密码（值示例 “[1]”表示配置了用户密码登录，“[2,3]”配置了手机+密码登录和手机+验证码登录）")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "body", name = "configItem", dataType = "UserLoginConfigReqDto", required = true, value = "用户登录配置信息") })
	RestResponse<String> postUserLoginConfig(@PathVariable("userId") Long userId, @RequestBody UserLoginConfigReqDto configItem);

	/**
	 * 修改用户登录配置
	 *
	 * @param userId 用户id
	 * @param configItem
	 *            用户登录配置信息请求实体
	 * @return 数据保存后的ID
	 */
	@PutMapping(value = "/{userId}/loginconfig", produces = "application/json")
	@ApiOperation(value = "用户登录配置修改", notes = "修改认证中心保存用户登录配置信息userId标志用户，configItem表示登录配置内容用户登录配置"
			+ "1用户名username+密码；2手机+密码；3手机+验证码；4身份证+密码；5邮箱+密码（值示例 “[1]”表示配置了用户密码登录，“[2,3]”配置了手机+密码登录和手机+验证码登录）")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "body", name = "configItem", dataType = "UserLoginConfigReqDto", required = true, value = "用户登录配置信息") })
	RestResponse<String> putUserLoginConfig(@PathVariable("userId") Long userId, @RequestBody UserLoginConfigReqDto configItem);

	/**
	 * 删除用户登录配置
	 *
	 * @param userId
	 *            用户唯一标识id
	 * @return String 数据保存后的ID
	 */
	@DeleteMapping(value = "/{userId}", produces = "application/json")
	@ApiOperation(value = "用户登录配置删除", notes = "根据用户id删除认证中心保存的用户登录配置信息")
	RestResponse<String> delUserLoginConfig(@PathVariable("userId") Long userId);

}
