/**
 * @(#) AppSecretReqDto.java 1.0 2019-01-21
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 第三方渠道配置
 *
 * @author 刘备
 * @since 1.0.0
 */
@ApiModel(value = "AppSecretReqDto", description = "第三方渠道配置请求Dto")
public class AppSecretReqDto extends RequestDto {

    @ApiModelProperty(value = "id,新增不需要填")
    private Long id;

    @ApiModelProperty(value = "第三方appId,必填")
    private String keyAppId;

    @ApiModelProperty(value = "第三方appSecret,必填")
    private String keyAppSecret;

    @ApiModelProperty(value = "第三方类型：1 微信， 2 QQ， 3 新浪， 4 支付宝， 5 钉钉,必填")
    private Integer thirdparyType;

    @ApiModelProperty(value = "登录来源：1. Web 2. App, 选填")
    private Integer loginSource;

    @ApiModelProperty(value = "状态：1可用   2禁用 , 必填")
    private Integer status;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "第三方的app配置,json格式存储的第三方开发者其他信息")
    private String keyAppConfig;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKeyAppConfig() {
        return keyAppConfig;
    }

    public void setKeyAppConfig(String keyAppConfig) {
        this.keyAppConfig = keyAppConfig;
    }

    public String getKeyAppId() {
        return keyAppId;
    }

    public void setKeyAppId(String keyAppId) {
        this.keyAppId = keyAppId;
    }

    public String getKeyAppSecret() {
        return keyAppSecret;
    }

    public void setKeyAppSecret(String keyAppSecret) {
        this.keyAppSecret = keyAppSecret;
    }

    public Integer getThirdparyType() {
        return thirdparyType;
    }

    public void setThirdparyType(Integer thirdparyType) {
        this.thirdparyType = thirdparyType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getLoginSource() {
        return loginSource;
    }

    public void setLoginSource(Integer loginSource) {
        this.loginSource = loginSource;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}