package com.dtyunxi.yundt.cube.center.identity.api.dto.request;


import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@ApiModel(value = "checkVerifyCodeAndModifyPasswordDto", description = "校验验证码同时重置密码请求dto")
public class CheckVerifyCodeAndModifyPasswordDto extends RequestDto {

    @ApiModelProperty(value = "验证码，必填")
    @NotEmpty
    private String verifyCode;

    @ApiModelProperty(value = "验证码后台生成时返回的唯一标识，必填")
    @NotEmpty
    private String uniqueId;

    @ApiModelProperty(value = "验证码类型：2手机验证码，3邮箱验证码，必填")
    @NotNull
    private Integer type;

    /**
     * 发送实体 如 手机：1364089665887
     */
    @ApiModelProperty(value = "发送实体 如 手机：1364089665887, 根据类型选填手机或邮箱")
    @NotEmpty
    private String target;

    @ApiModelProperty(value = "账号域，选填")
    private String domain;

    @ApiModelProperty(value = "新密码，必填")
    @NotEmpty
    private String newPassword;

    public String getVerifyCode() {
        return verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }
}
