/*
 * *
 *  * @(#)MemberRegisterReqDto.java 2.0.0 3/12/19 7:37 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.util.Date;
import java.util.List;

/**
 * @author luo.lei
 * @since 2.0.0
 */
public class MemberRegisterReqDto extends BaseReqDto {


    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名, 根据注册方式选填")
    private String userName;

    /**
     * 需要绑定的第三方平台的用户
     */
    @ApiModelProperty(value = "需要绑定的第三方平台的用户, 选填")
    private List<BindingReqDto> bindings;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码, 根据注册方式选填")
    private String password;

    @ApiModelProperty(value = "盐值, 选填")
    private String salt;

    /**
     * 验证码
     */
    @ApiModelProperty(value = "验证码, 根据注册方式选填")
    private String verifyCode;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱, 根据注册方式选填")
    @Email
    private String email;

    /**
     * 手机
     */
    @ApiModelProperty(value = "手机, 根据注册方式选填")
    private String phone;


    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码, 选填")
    private String channelCode;

    /**
     * 如果有请求发送了验证码需要再注册中验证有效性需要传发送验证码成功后返回的字符串即是uniqueId
     */
    @ApiModelProperty(value = "传发送验证码成功后返回的字符串即是uniqueId, 若选择需要验证码的方式必填")
    private String uniqueId;

    /**
     * 1手机+验证码2手机+验证码+密码3邮箱注册+密码+验证码激活4用户名+密码
     */
    @Min(1)
    @Max(4)
    @ApiModelProperty(value = "1手机+验证码2手机+验证码+密码3邮箱注册+密码+验证码激活4用户名+密码, 必填")
    private Integer registerType;

    @ApiModelProperty(value = "默认用户等级, 选填")
    private String defaultModelLevelName;

    @ApiModelProperty(value = "会员中心用户id, 选填")
    private Long userId;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称, 选填")
    private String nickName;

    /**
     * 头像
     */
    @ApiModelProperty(value = "头像, 选填")
    private String avatar;

    @ApiModelProperty(value = "注册时间, 选填")
    private Date registerTime;

    @ApiModelProperty(value = "1启用2禁用, 默认为1")
    private Integer status;

    @ApiModelProperty(value = "用户分类, 潜客用户类型为0 会员用户类型是1, 选填")
    private Integer userType;

    //TODO 用户中心userDto 的扩展参数：存放其他业务参数
    @ApiModelProperty(value = "扩展参数，格式为JSON, 选填", allowEmptyValue = true)
    private String extraParams;

    @ApiModelProperty(name = "sex", value = "性别")
    private String sex;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    List<AddressReqDto> addressList;

    public String loginName() {
        String loginName = "";
        switch (this.getRegisterType()) {
            case 1:
            case 2:
                loginName = this.getPhone();
                break;
            case 3:
                loginName = this.getEmail();
                break;
            case 4:
                loginName = this.getUserName();
                break;
        }
        return loginName;
    }


//    public MemberReqDto toMemberReqDto() {
//        MemberReqDto memberDto = new MemberReqDto();
//        memberDto.setActivateTime(new Date());
//        memberDto.setCreateTime(new Date());
//        memberDto.setGrowthValue(0);
//        memberDto.setLevelName("");
//        memberDto.setUserId(this.getUserId());
//        memberDto.setName(this.loginName());
//        memberDto.setStatus(1);
//        memberDto.setUserSource("");
//        //memberDto.setUserType(this.getUserType());
//        memberDto.setTenantId(this.getTenantId());
//        return memberDto;
//    }


    public UserReqDto toUserReqDto() {
        UserReqDto dto = new UserReqDto();
        dto.setChannelCode(this.getChannelCode());
        dto.setEmail(this.getEmail());
        dto.setPassword(this.getPassword());
        dto.setSalt(this.getSalt());
        dto.setConfirmPassword(this.getPassword());
        dto.setPhone(this.getPhone());

        dto.setRegisterType(this.getRegisterType());
        dto.setUniqueId(this.getUniqueId());
        dto.setUserName(this.getUserName());
        dto.setInstanceId(this.getInstanceId());
        dto.setTenantId(this.getTenantId());
        dto.setVerifyCode(this.getVerifyCode());

        dto.setNickName(this.getNickName());
        dto.setAvatar(this.getAvatar());
        dto.setRegisterTime(this.getRegisterTime());
        dto.setUserType(this.getUserType());
        dto.setStatus(this.getStatus());
        dto.setId(this.getUserId());
        dto.setExtraParams(this.getExtraParams());
        dto.setExtension(this.getExtension());
        dto.setExtFields(this.getExtFields());

        return dto;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getDefaultModelLevelName() {
        return defaultModelLevelName;
    }

    public void setDefaultModelLevelName(String defaultModelLevelName) {
        this.defaultModelLevelName = defaultModelLevelName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVerifyCode() {
        return verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Integer getRegisterType() {
        return registerType;
    }

    public void setRegisterType(Integer registerType) {
        this.registerType = registerType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getExtraParams() {
        return extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public List<BindingReqDto> getBindings() {
        return bindings;
    }

    public void setBindings(List<BindingReqDto> bindings) {
        this.bindings = bindings;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public List<AddressReqDto> getAddressList() {
        return addressList;
    }

    public void setAddressList(List<AddressReqDto> addressList) {
        this.addressList = addressList;
    }
}
