/*
 * @(#)MessageReqDto.java 1.0 2018-10-22
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "MessageReqDto", description = "验证码消息dto")
public class MessageReqDto extends RequestDto {
	/**
	 * 类型 1 短信 2 邮箱
	 */
	@ApiModelProperty(value = "类型 1 短信 2 邮箱, 必填")
	@NotNull
	private Integer type;
	/**
	 * 发送实体 如 手机：1364089665887
	 */
	@ApiModelProperty(value = "发送实体 如 手机：1364089665887, 根据类型选填手机或邮箱")
	@NotEmpty
	private String target;

	@ApiModelProperty(value = "校验手机号或邮箱是否存在已注册账号，true：校验，选填")
	private boolean checkAccount;

	@ApiModelProperty(value = "账号域，选填")
	private String domain;

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	public boolean isCheckAccount() {
		return checkAccount;
	}

	public void setCheckAccount(boolean checkAccount) {
		this.checkAccount = checkAccount;
	}

	public String getDomain() {
		return domain;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}
}