/**
 * @(#) ResetPasswordReqDto.java 1.0 2019-03-20
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author 刘备
 * @since 1.0.0
 */
@ApiModel(value = "ResetPasswordReqDto", description = "重置密码的请求DTO")
public class ResetPasswordReqDto extends RequestDto {

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码, 必填")
    private String phone;

    /**
     * 验证码唯一id
     */
    @ApiModelProperty(value = "图形验证码唯一id, 必填")
    @NotNull
    private String uniqueId;

    /**
     * 验证码
     */
    @ApiModelProperty(value = "验证码, 必填")
    @NotNull
    private String verifyCode;

    /**
     * 新密码
     */
    @ApiModelProperty(value = "新密码, 必填")
    @NotNull
    private String newPassword;

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getVerifyCode() {
        return verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }
}