/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 登陆用户传输dto
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "UserBindLoginThirdDto", description = "登陆绑定第三方")
public class UserBindLoginThirdDto extends RequestDto {
    private static final long serialVersionUID = -596882374227258344L;

    /**
     * 登陆类型
     */
    @ApiModelProperty(value = "第三方类型（1：微信，2：QQ，3：Sina微博，4：钉钉，5：FACEBOOK，6：小程序 7：苹果  8:LDAP 9:支付宝）", required = true)
    @Min(1)
    @Max(10)
    @NotNull
    private Integer thirdType;

    @ApiModelProperty(value = "第三方生产的openId")
    private String openId;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码,当使用小程序获取手机号进行注册登陆时。此处存放小程序getPhoneNumber返回的encryptedData")
    private String phone;

    @ApiModelProperty(value = "加密算法的初始向量")
    private String iv;

    /**
     * 短信验证码
     */
    @ApiModelProperty(value = "短信验证码")
    private String checkCode;

    /**
     * 短信验证码唯一id
     */
    @ApiModelProperty(value = "短信验证码唯一id")
    private String checkCodeUniqueId;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码")
    private String password;

    @ApiModelProperty(value = "用户类型")
    private Integer userType;

    @ApiModelProperty(value = "第三方生产的token(绑定时候需要用到)")
    private String thirdToken;

    /**
     * 调用方可以设置认证中心所返回token的有效时间，单位秒；如果没有设置，则使用认证中心配置的默认值
     */
    @ApiModelProperty(value = "指定返回Token的有效时间（秒）")
    private Integer validTime;

    /**
     * 加以下参数，支持支付宝登录，获取用户信息
     */
    @ApiModelProperty(value = "登录来源：（1.网站 2.应用 3.小程序）。当第三方用户来源有多个登录来源时使用，如微信，有app微信登录，微信小程序登录。与com.dtyunxi.yundt.cube.center.identity.api.dto.request#UserLoginReqDto无关联。选填")
    private Integer loginSource;

    @ApiModelProperty(value = "配置级别：1 租户级别 2 应用级别, 选填")
    private Integer configLevel;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名，选填")
    private String userName;

    /**
     * 用户昵称
     */
    @ApiModelProperty(value = "用户昵称, 选填")
    private String nickName;

    /**
     * 用户头像url地址
     */
    @ApiModelProperty(value = "用户头像url地址, 选填")
    private String avatar;

    /**
     * 用户地址信息
     */
    @ApiModelProperty(value = "用户地址信息")
    private AddressReqDto addressReqDto;

    @ApiModelProperty(value = "账号域")
    private String domain;

    public String getCheckCodeUniqueId() {
        return checkCodeUniqueId;
    }

    public void setCheckCodeUniqueId(String checkCodeUniqueId) {
        this.checkCodeUniqueId = checkCodeUniqueId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public Integer getThirdType() {
        return thirdType;
    }

    public void setThirdType(Integer thirdType) {
        this.thirdType = thirdType;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getThirdToken() {
        return thirdToken;
    }

    public void setThirdToken(String thirdToken) {
        this.thirdToken = thirdToken;
    }

    public Integer getValidTime() {
        return validTime;
    }

    public void setValidTime(Integer validTime) {
        this.validTime = validTime;
    }

    public String getIv() {
        return iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }


    public Integer getLoginSource() {
        return loginSource;
    }

    public void setLoginSource(Integer loginSource) {
        this.loginSource = loginSource;
    }

    public Integer getConfigLevel() {
        return configLevel;
    }

    public void setConfigLevel(Integer configLevel) {
        this.configLevel = configLevel;
	}
	
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
    
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public AddressReqDto getAddressReqDto() {
        return addressReqDto;
    }

    public void setAddressReqDto(AddressReqDto addressReqDto) {
        this.addressReqDto = addressReqDto;
    }
}