/**
 * @(#) UserLoginConfigDto.java 1.0 2018-08-31
 * 
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户登录配置信息Dto
 * 
 * @author 项羽
 * @since 2.0.0
 */
@ApiModel(value = "UserLoginConfigReqDto", description = "用户登录配置请求参数Dto")
public class UserLoginConfigReqDto extends RequestDto {

	private static final long serialVersionUID = -5324816712440464341L;

	@ApiModelProperty(value = "用户唯一标识, 必填")
	private Long userId;
	/**
	 * (1,用户名+密码)（2，手机+密码），（3，手机+验证码），（4，邮箱+密码），（5,身份证+加密码） 用户登陆配置
	 * 1用户名username+密码；2手机+密码；3手机+验证码；4身份证+密码；5邮箱+密码；
	 */
	@ApiModelProperty(value = "用户登陆配置(1,用户名+密码)（2，手机+密码），（3，手机+验证码），（4，邮箱+密码），（5,身份证+加密码）；" +
			"（值示例 “1”表示配置了用户密码登陆，“2,3”配置了手机+密码登陆和手机+验证码登陆）, 必填")
	private String loginConfig;

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getLoginConfig() {
		return loginConfig;
	}

	public void setLoginConfig(String loginConfig) {
		this.loginConfig = loginConfig;
	}

}
