/**
 * @(#) SsoInstanceRespDto.java 1.0 2020-04-07
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户授权访问的应用列表
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "SsoAppInstanceRespDto", description = "用户授权访问的应用列表")
public class SsoAppInstanceRespDto {

    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 业务空间code
     */
    @ApiModelProperty(value = "业务空间code")
    private String bizSpaceCode;

    /**
     * 应用实例编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 应用实例名称
     */
    @ApiModelProperty(value = "应用名称")
    private String appInsName;

    /**
     * 状态：1，启用；2，禁用
     */
    @ApiModelProperty(value = "状态：1，启用；2，禁用")
    private Integer status;

    /**
     * 访问入口
     */
    @ApiModelProperty(value = "访问入口")
    private String hostName;

    /**
     * 应用key
     */
    @ApiModelProperty(value = "应用key")
    private String appKey;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAppInsName() {
        return appInsName;
    }

    public void setAppInsName(String appInsName) {
        this.appInsName = appInsName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}
