/*
 * @(#)ResTokenDto.java 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;

/**
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "ResTokenDto", description = "登陆后返回的tokenDto")
public class TokenRespDto extends BaseVo {

    @ApiModelProperty(value = "用户ID")
    private Long userId;
    /**
     * token
     */
    @ApiModelProperty(value = "token")
    private String token;
    @ApiModelProperty(value = "需要图形验证码校验")
    private Map<String, String> imageCode;

    @ApiModelProperty(value = "true:需要修改密码；false:不需要")
    private Boolean needModifyPassword;

    @ApiModelProperty(value = "用户登陆新的校验方式：0 滑块验证 1 手机验证 2 用户已被冻结")
    private Integer newValidWay;

    /**
     * token 有效时间
     */
    @ApiModelProperty(value = "当前token 有效时间（秒）")
    private Integer tokenValidTime;

    public Integer getNewValidWay() {
        return newValidWay;
    }

    public void setNewValidWay(Integer newValidWay) {
        this.newValidWay = newValidWay;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Map<String, String> getImageCode() {
        return imageCode;
    }

    public void setImageCode(Map<String, String> imageCode) {
        this.imageCode = imageCode;
    }

    public Boolean getNeedModifyPassword() {
        return needModifyPassword;
    }

    public void setNeedModifyPassword(Boolean needModifyPassword) {
        this.needModifyPassword = needModifyPassword;
    }

    public Integer getTokenValidTime() {
        return tokenValidTime;
    }

    public void setTokenValidTime(Integer tokenValidTime) {
        this.tokenValidTime = tokenValidTime;
    }

}