package com.dtyunxi.yundt.cube.center.identity.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.IDPUserRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 *
 * @author chenxi
 * @since 1.0.0
 */
@Api(tags = {"认证中心：获取idp相关信息"})
public interface IDPQueryApi {
    /**
     * 通过租户id获取idp登录地址
     *
     * @param tenantId 租户id
     * @return
     */
    @GetMapping(value = "login_url/tenant_id/{tenantId}")
    @ApiOperation(value = "通过租户id获取idp登录地址", notes = "通过租户id获取idp登录地址")
    @ResponseBody
    RestResponse<String> QueryByTenantId(@PathVariable("tenantId") Long tenantId);

    /**
     * 根据租户id,token查询用户信息
     * @param authorization
     * @return
     */
    @GetMapping("/authorization/{tenantId}")
    @ApiOperation(value = "根据token查询用户信息", notes = "根据token查询用户信息")
    @ResponseBody
    RestResponse<IDPUserRespDto> queryUserByToken(@RequestHeader(name = "Authorization") String authorization,
                                                  @PathVariable("tenantId") Long tenantId);
}
