package com.dtyunxi.yundt.cube.center.identity.api.v3.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginLogQueryReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.LoginLogRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 登录日志查询api
 * @author 青竹
 */
@Api(tags = {"认证中心：登录日志服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-v3-query-ILoginLogQueryApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v3/user/log", url = "${yundt.cube.center.identity.api:}")
public interface ILoginLogQueryApi {

    /**
     * 根据条件查询登录日志信息
     * 分页请根据参数：当前页pageNum、每页记录条数pageSize、总页数pages、总记录条数total、记录列表数据list展示
     * 其他参数值无效
     *
     * @param filter 过滤条件
     * @param pageNum 起始页
     * @param pageSize 每页记录数
     * @return
     */
    @Deprecated
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(value = "根据条件查询登录日志信息(该方法适用走es查询(默认走mysql查询)，支持通过配置项设定走es查询)", notes = "filter == LoginLogReqDto, 可以根据：用户名、登录IP、时间范围、角色编码、（登录/注销）进行搜索查询\n "
                                                    + "分页请根据参数：当前页pageNum、每页记录条数pageSize、总页数pages、总记录条数total、记录列表数据list展示\n "
                                                    + "其他参数值无效\n" +
            "{\n" +
            "\"instanceId\":1,\n" +
            "\"tenantId\":1,\n" +
            "\"beginTime\":\"必传，yyyy-MM-dd HH:mm:ss\",\n" +
            "\"endTime\":\"必传，yyyy-MM-dd HH:mm:ss\",\n" +
            "\"userName\":\"xxx\",\n" +
            "\"clientIp\":\"登录Ip\",\n" +
            "\"status\":\"登录状态：1登录成功 2退出登录\",\n" +
            "\"roleCode\":\"角色编码，查询多个角色请使用英文逗号分隔\"\n" +
            "}\n" +
            "单次查询限额1000条\n")
    RestResponse<PageInfo<LoginLogRespDto>> findList(@RequestParam("filter") String filter,
                                                     @RequestParam("pageNum") Integer pageNum,
                                                     @RequestParam("pageSize") Integer pageSize);

    /**
     * 根据条件查询登录日志信息
     *
     * @param loginLogQueryReqDto 请求体
     * @param pageNum             当前页
     * @param pageSize            每页记录数
     * @return 分页信息
     */
    @GetMapping
    @ApiOperation(value = "根据条件查询登录日志信息", notes = "根据条件查询登录日志信息(该方法适用走mysql查询(默认走mysql查询)，支持通过配置项设定走es查询)")
    RestResponse<PageInfo<LoginLogRespDto>> queryPage(@SpringQueryMap LoginLogQueryReqDto loginLogQueryReqDto,
                                                      @RequestParam("pageNum") Integer pageNum,
                                                      @RequestParam("pageSize") Integer pageSize);

}
