/**
 * @(#) IUserLoginConfigQueryApi.java 1.0 2018-09-03
 * 
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.v3.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;

/**
 * 登录配置信息查询API
 * 
 * @author 项羽
 * @since 2.0.0
 */
@Api(tags = { "认证中心：用户登录配置信息查询接口" })
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-v3-query-IUserLoginConfigQueryApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v3/user", url = "${yundt.cube.center.identity.api:}")
public interface IUserLoginConfigQueryApi {
	/**
	 * 获取用户登录配置
	 *
	 * @param userId 用户唯一标识id
	 * @return String 数据保存后的ID
	 */
	@GetMapping(value = "/{id}/login-config", produces = "application/json")
	@ApiOperation(value = "用户登录配置获取", notes = "根据用户id获取认证中心保存的用户登录配置信息.登录配置值示例1用户名username+密码；2手机+密码；3手机+验证码；4身份证+密码；5邮箱+密码（返回 “1”表示配置了用户密码登录，“2,3”配置了手机+密码登录和手机+验证码登录）没有配置默认都支持")
	RestResponse<String> getUserLoginConfig(@NotNull @PathVariable("id") Long userId);

	/**
	 * 获取用户登录配置
	 *
	 * @param filters 过滤条件
	 * @param pageNum 页码
	 * @param pageSize 页大小
	 * @return String 数据保存后的ID
	 */
	@GetMapping(value = "/login-config", produces = "application/json")
	@ApiOperation(value = "用户登录配置获取", notes = "filters == UserLoginConfigReqDto, 登录配置值示例1用户名username+密码；" +
			"2手机+密码；3手机+验证码；4身份证+密码；5邮箱+密码（返回 “1”表示配置了用户密码登录，“2,3”配置了手机+密码登录和手机+验证码登录）没有配置默认都支持\n" +
			"单次查询限额1000条\n")
	RestResponse<PageInfo<UserLoginConfigReqDto>> getUserLoginConfigs(@RequestParam("filters") String filters,
                                                                      @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);
}
