/**
 * @(#) SortEnum.java 1.0 2020-06-01
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.constant;

/**
 * 字段类型枚举
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum FieldTypeEnum {
    COMMON(1, "通用字段"),
    CUSTOM(2, "自定义字段")
    ;

    private Integer type;
    private String desc;

    FieldTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (FieldTypeEnum sort : FieldTypeEnum.values()) {
            if (type.equals(sort.getType())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
