package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel(value = "AppInstanceInitDto", description = "应用重新初始化菜单按钮请求dto")
public class AppInstanceInitDto {

    @NotNull
    @ApiModelProperty(value = "应用ID")
    private Long instanceId;

    @NotEmpty
    @ApiModelProperty(value = "资源菜单编码列表")
    private List<String> menuCodes;

    @ApiModelProperty(value = "资源按钮编码列表")
    private List<String> buttonCodes;

    @ApiModelProperty(value = "是否对旧的菜单或按钮列表有且新的菜单或按钮列表也有的元素进行更新(默认是true)")
    private Boolean updateOld = true;

    @ApiModelProperty(value = "是否对旧的菜单或按钮列表有且新的菜单或按钮列表没有的元素进行删除(默认是true)")
    private Boolean deleteOld = true;

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<String> getMenuCodes() {
        return menuCodes;
    }

    public void setMenuCodes(List<String> menuCodes) {
        this.menuCodes = menuCodes;
    }

    public List<String> getButtonCodes() {
        return buttonCodes;
    }

    public void setButtonCodes(List<String> buttonCodes) {
        this.buttonCodes = buttonCodes;
    }

    public Boolean getUpdateOld() {
        return updateOld;
    }

    public void setUpdateOld(Boolean updateOld) {
        this.updateOld = updateOld;
    }

    public Boolean getDeleteOld() {
        return deleteOld;
    }

    public void setDeleteOld(Boolean deleteOld) {
        this.deleteOld = deleteOld;
    }
}
