/**
 * @(#) ExpressionConfigDto.java 1.0 2020-07-08
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "ExpressionConfigGroupDto", description = "数据权限规则模板逻辑配置分组请求对象")
public class ExpressionConfigGroupDto extends RequestDto {

    /**
     *  引用实体编码
     */
    @ApiModelProperty(value = "引用实体编码，当设置关联表其他条件时，必填")
    private String refEntityCode;

    /**
     *  逻辑配置
     */
    @NotEmpty
    @ApiModelProperty(value = "逻辑配置，必填")
    private List<ExpressionConfigDto> expressionConfigs = Lists.newArrayList();

    /**
     *  关系运算符
     */
    @ApiModelProperty(value = "关系运算符，默认OR")
    private String relationalOperator;

    public String getRefEntityCode() {
        return refEntityCode;
    }

    public void setRefEntityCode(String refEntityCode) {
        this.refEntityCode = refEntityCode;
    }

    public List<ExpressionConfigDto> getExpressionConfigs() {
        return expressionConfigs;
    }

    public void setExpressionConfigs(List<ExpressionConfigDto> expressionConfigs) {
        this.expressionConfigs = expressionConfigs;
    }

    public String getRelationalOperator() {
        return relationalOperator;
    }

    public void setRelationalOperator(String relationalOperator) {
        this.relationalOperator = relationalOperator;
    }
}
