/**
 * @(#) RuleTmplRefConfigDto.java 1.0 2020-07-08
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "RuleTmplRefConfigDto", description = "数据权限规则模板引用配置请求对象")
public class RuleTmplRefConfigDto extends RequestDto {
    /**
     *  被引用的规则模板ID
     */
    @NotNull
    @ApiModelProperty(value = "被引用的规则模板ID")
    private Long refRuleTmplId;

    /**
     *  关系运算符
     */
    @NotEmpty
    @ApiModelProperty(value = "关系运算符，必填")
    private String relationalOperator;

    public Long getRefRuleTmplId() {
        return refRuleTmplId;
    }

    public void setRefRuleTmplId(Long refRuleTmplId) {
        this.refRuleTmplId = refRuleTmplId;
    }

    public String getRelationalOperator() {
        return relationalOperator;
    }

    public void setRelationalOperator(String relationalOperator) {
        this.relationalOperator = relationalOperator;
    }

}
