/**
 * @(#) DataLimitExceptionCode.java 1.0 2020-07-06
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.limit.api.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;

/**
 * 异常码定义
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum DataLimitExceptionCode implements IExceptionEnum {

    DATA_LIMIT_RULE_TMPL_NOT_EXIST("5001", "数据权限基础配置不存在"),
    DATA_LIMIT_RULE_NOT_EXIST("5002", "数据权限规则不存在"),
    DATA_LIMIT_RULE_TMPL_CODE_EXIST("5003", "应用实例下实体字段对应的权限基础配置已存在，不能重复添加"),
    DATA_LIMIT_RULE_CODE_EXIST("5004", "数据权限规则编码已存在"),
    DATA_LIMIT_RULE_TMPL_CAN_NOT_DELETE("5005", "已生成规则的权限基础配置不能被删除"),
    SCENE_CODE_DEFAULT_EXIST("5006", "角色在该实体下已配置默认场景规则"),
    SCENE_FLAG_EXIST("5007", "该角色，对规则对应的实体，已配置相同场景规则"),
    FIELD_LIMIT_RULE_CODE_EXIST("5008", "字段权限规则编码已存在"),
    FIELD_LIMIT_RULE_NOT_EXIST("5009", "字段权限规则不存在"),
    DATA_LIMIT_RULE_ROLE_ID_IS_NULL("5010", "据权限规则关联角色id不能为空"),
    DATA_LIMIT_RULE_ROLE_NOT_EXISTS("5011", "数据权限规则关联角色不存在"),
    DATA_LIMIT_RULE_EXISTS("5012", "该角色在该实体下已经存在规则，不能重复添加"),
    DATA_LIMIT_RULE_CANT_CUSTOM_RULS_SCENE("5013", "无法在默认场景下新建特殊规则"),
    DATA_LIMIT_RULE_INVALID_IDENTITY_TYPE("5014", "身份类型错误!"),
    DATA_LIMIT_RULE_ID_LINK_NOT_EXIST("5015", "数据权限身份关联配置不存在"),
    ;

    private final String code;
    private final String msg;

    DataLimitExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;

    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    /**
     * 使用枚举信息构建业务异常
     *
     * @return 业务异常
     */
    public BizException buildBizException() {
        return new BizException(this.code, this.msg);
    }
}
