package com.dtyunxi.yundt.cube.center.data.limit.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RuleConfigQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.UserDataLimitRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 数据权限规则服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"用户中心：数据权限规则服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IDataLimitRuleQueryApi", path = "/v1/data-limit-rule",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IDataLimitRuleQueryApi {

    /**
     * 根据id查询数据权限规则
     *
     * @param id 数据权限规则id
     * @return 数据权限规则数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询数据权限规则", notes = "根据id查询数据权限规则")
    RestResponse<DataLimitRuleRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 数据权限规则分页数据
     *
     * @param reqDto   数据权限规则查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 数据权限规则分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "数据权限规则分页数据", notes = "根据filter查询条件查询数据权限规则数据")
    RestResponse<PageInfo<DataLimitRuleRespDto>> queryByPage(@SpringQueryMap DataLimitRuleReqDto reqDto,
                                                             @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据用户id及实体列表，查询规则集合数据
     *
     * @param reqDto 查询条件
     * @return 用户信息及数据权限规则列表
     */
    @GetMapping("/user")
    @ApiOperation(value = "根据用户id及实体列表，查询规则集合数据", notes = "根据用户id及实体列表，查询规则集合数据")
    RestResponse<UserDataLimitRuleQueryRespDto> queryUserDataLimitRule(@SpringQueryMap UserDataLimitRuleQueryReqDto reqDto);

    /**
     * 根据id查询数据权限规则条件配置
     *
     * @param queryReqDto 数据权限规则id
     * @return 数据权限规则条件配置
     */
    @GetMapping("/expression")
    @ApiOperation(value = "根据id查询数据权限规则条件配置", notes = "根据id查询数据权限规则条件配置")
    RestResponse<RuleConfigRespDto> queryExpression(@SpringQueryMap RuleConfigQueryReqDto queryReqDto);

    /**
     * 根据id查询数据权限规则条件配置
     *
     * @param queryReqDto 数据权限规则id
     * @return 数据权限规则条件配置
     */
    @GetMapping("/expression/list")
    @ApiOperation(value = "根据id查询数据权限规则条件配置", notes = "根据id查询数据权限规则条件配置")
    RestResponse<List<RuleConfigRespDto>> queryExpressionPage(@SpringQueryMap RuleConfigQueryReqDto queryReqDto,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 忽略数据权限规则分页数据
     *
     * @param queryReqDto 过略条件
     * @param pageNum     页数
     * @param pageSize    每页记录数
     * @return 忽略数据权限规则分页数据
     */
    @GetMapping("/ignore")
    @ApiOperation(value = "忽略数据权限规则分页数据", notes = "根据filter查询条件查询数据权限规则数据")
    RestResponse<PageInfo<IgnoreRuleQueryResDto>> queryIgnoreRuleByPage(@SpringQueryMap IgnoreRuleQueryReqDto queryReqDto,
                                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
