package com.dtyunxi.yundt.cube.center.data.limit.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
* 字段权限规则服务接口
*
* @author 代码生成器
*/
@Api(tags = {"用户中心：字段权限规则服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IFieldLimitRuleQueryApi",
        path = "/v1/field-limit-rule",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IFieldLimitRuleQueryApi {

    /**
    * 根据id查询字段权限规则
    *
    * @param reqDto 字段权限规则id
    * @return   字段权限规则数据
    */
    @GetMapping("/by-id")
    @ApiOperation(value = "根据id查询字段权限规则", notes = "根据id查询字段权限规则")
    RestResponse<FieldLimitRuleDetailRespDto> queryById(@SpringQueryMap FieldLimitRuleReqDto reqDto);

    /**
    * 字段权限规则分页数据
    *
    * @param reqDto   字段权限规则查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 字段权限规则分页数据
    */
    @GetMapping("")
    @ApiOperation(value = "字段权限规则分页数据", notes = "根据FieldLimitRuleReqDto查询条件查询字段权限规则数据")
    RestResponse<PageInfo<FieldLimitRuleRespDto>> queryByPage(@SpringQueryMap FieldLimitRuleQueryReqDto reqDto,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 查询字段权限通用字段列表
     *
     * @return 字段权限通用字段列表
     */
    @GetMapping("/common-field")
    @ApiOperation(value = "查询字段权限通用字段列表", notes = "查询字段权限通用字段列表")
    RestResponse<List<CommonFieldRespDto>> queryCommonField();


    /**
     * 字段权限-可选择角色列表查询
     *
     * @param queryReqDto 查询条件
     * @return   应用角色数据
     */
    @GetMapping("/instance/role")
    @ApiOperation(value = "字段权限-可选择角色列表查询", notes = "字段权限-可选择角色列表查询")
    RestResponse<List<AppInstanceAndRoleRespDto>> queryAppInstanceAndRole(@SpringQueryMap FieldLimitRuleReqDto queryReqDto);


    /**
     * 字段权限-规则已关联/未关联角色查询
     *
     * @param queryReqDto   角色查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 角色分页数据
     */
    @GetMapping("/role")
    @ApiOperation(value = "字段权限-规则已关联/未关联角色查询", notes = "根据FieldLimitRuleReqDto字段权限-规则已关联/未关联角色查询")
    RestResponse<PageInfo<RoleQueryRespDto>> queryRoleByPage(@SpringQueryMap RoleQueryReqDto queryReqDto,
                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据用户id及领域编码，查询字段权限规则集合数据
     *
     * @param queryReqDto 查询条件
     * @return 字段权限规则集合数据
     */
    @GetMapping("/user")
    @ApiOperation(value = "根据用户id及领域编码，查询字段权限规则集合数据", notes = "根据用户id及领域编码，查询字段权限规则集合数据")
    RestResponse<UserFieldLimitRuleQueryRespDto> queryUserFieldLimitRule(@SpringQueryMap UserFieldLimitRuleQueryReqDto queryReqDto);
}
