package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ApiBindReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ApiReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * API操作接口
 *
 * @author 代码生成器
 */
@Api(tags = {"用户中心：API操作接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IApiApi",path = "/v1/api", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IApiApi {

    /**
     * 新增API
     *
     * @param reqDto API请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增API", notes = "新增API")
    @Capability(capabilityCode = "user.api.add-api")
    RestResponse<Long> addApi(@RequestBody @Valid ApiReqDto reqDto);

    /**
     * 修改API
     *
     * @param id API id
     * @param reqDto API请求对象
     * @return 处理结果
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "修改API", notes = "修改API")
    @Capability(capabilityCode = "user.api.modify-api")
    RestResponse<Void> modifyApi(@PathVariable("id") Long id, @RequestBody ApiReqDto reqDto);

    /**
     * 删除API
     *
     * @param id API id
     * @return 处理结果
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除API", notes = "删除API")
    @Capability(capabilityCode = "user.api.remove-api")
    RestResponse<Void> removeApi(@PathVariable("id") Long id);


    /**
     * API绑定资源
     *
     * @param bindReqDto API关联资源对象
     * @return
     */
    @PostMapping("/bind/resource")
    @ApiOperation(value = "API绑定资源", notes = "API绑定资源")
    @Capability(capabilityCode = "user.api.bind-resource")
    RestResponse<Void> bindResource(@RequestBody @Valid ApiBindReqDto bindReqDto);

    /**
     * API解绑资源
     *
     * @param bindReqDto API关联资源对象
     * @return
     */
    @PostMapping("/unbind/resource")
    @ApiOperation(value = "API解绑资源", notes = "API解绑资源")
    @Capability(capabilityCode = "user.api.unbind-resource")
    RestResponse<Void> unbindResource(@RequestBody @Valid ApiBindReqDto bindReqDto);

}
