package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.HurdleDefinitionDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.HurdleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.HurdleInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.HurdleDefinitionVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 *
 * @author luban
 * @date 2020-06-17
 */
@Api(tags = {"用户中心：BOC首页通知栏配置"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IHurdleDefinitionApi",path = "/v1/hurdleDefinition", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IHurdleDefinitionApi {

    @RequestMapping(value = {"/{userId}"}, method = RequestMethod.GET)
    @ApiOperation(value = "获取栏位配置信息", notes = "获取栏位配置信息")
    RestResponse<List<HurdleDefinitionVo>> queryHurdleDefinitions(@PathVariable("userId") Long userId);

    @RequestMapping(value = {"/hurdles"}, method = RequestMethod.GET)
    @ApiOperation(value = "获取所有栏位分类", notes = "获取所有栏位分类")
    RestResponse<List<HurdleDto>> queryAllHurdles();

    @RequestMapping(value = {"/hurdle/{code}"}, method = RequestMethod.GET)
    @ApiOperation(value = "通过栏位编码获取栏位详情", notes = "通过栏位编码获取栏位详情")
    RestResponse<List<HurdleInfoDto>> queryHurdleInfoByHurdleCode(@PathVariable("code") String code);

    @RequestMapping(value = {""}, method = RequestMethod.POST)
    @ApiOperation(value = "添加栏位配置信息", notes = "添加栏位配置信息")
    RestResponse<Void> addHurdleDefinition(@RequestBody HurdleDefinitionDto hurdleDefinitionDto);

    @RequestMapping(value = {"/{id}"}, method = RequestMethod.PUT)
    @ApiOperation(value = "修改栏位配置信息", notes = "修改栏位配置信息")
    RestResponse<Void> updateHurdleDefinition(@PathVariable("id") Long id, @RequestBody HurdleDefinitionDto hurdleDefinitionDto);


    @RequestMapping(value = {"/{id}"}, method = RequestMethod.DELETE)
    @ApiOperation(value = "删除栏位配置信息", notes = "删除栏位配置信息")
    RestResponse<Void> deleteHurdleDefinition(@PathVariable("id") Long id);

    /**
     * 分页获取栏位信息
     * @param type 栏位类别
     * @param pageNum 当前页
     * @param pageSize 当前页数据量
     * @return 栏位分页信息
     */
    @RequestMapping(value = {"/page"}, method = RequestMethod.GET)
    @ApiOperation(value = "分页获取栏位信息", notes = "分页获取栏位信息")
    RestResponse<PageInfo<HurdleDto>> queryPage(@RequestParam(name = "type", required = false) String type, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);
}
