package com.dtyunxi.yundt.cube.center.user.api.constant;


import com.dtyunxi.yundt.cube.center.user.api.dto.response.EnumRespDto;

import java.util.ArrayList;
import java.util.List;

/**
 * 枚举类工具
 * @Author : 萧玄
 * @Date: 16:50 2019/6/19
 */
public class EnumUtils {

    /**
     * 返回枚举值
     * @Author : 萧玄
     * @Date   : 16:51 2019/6/19
     * @param iEnums
     * @param key
     * @Return : java.lang.String
     */
    public static String getValue(IEnum[]iEnums, Integer key){
        if (key == null){
            return null;
        }
        for(IEnum iEnum : iEnums){
            if(iEnum.getKey() == key){
                return iEnum.getValue();
            }
        }
        return null;
    }

    /**
     * 返回枚举
     * @Author : 萧玄
     * @Date   : 16:51 2019/6/19
     * @param iEnums
     * @param key
     * @Return : java.lang.String
     */
    public static <ENUM extends IEnum>  ENUM getEnum(ENUM[]iEnums, Integer key){
        if (key == null){
            return null;
        }
        for(ENUM iEnum : iEnums){
            if(iEnum.getKey() == key){
                return iEnum;
            }
        }
        return null;
    }

    public static List<EnumRespDto> getEnumRespDtoList(IEnum[] values){
        List<EnumRespDto> enumRespDtoList = new ArrayList<>(values.length);
        for (IEnum iEnum : values){
            EnumRespDto enumRespDto = new EnumRespDto();
            enumRespDto.setKey(iEnum.getKey());
            enumRespDto.setValue(iEnum.getValue());
            enumRespDtoList.add(enumRespDto);
        }
        return enumRespDtoList;
    }

}
