/**
 * @(#) DirSortEnum.java 1.0 2018-11-07
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.constant;

import org.apache.commons.lang3.StringUtils;

/**
 * 排序枚举
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum SortEnum {

    BOTTOM("BOTTOM", "置底"),
    INCR("INCR", "升序 1"),
    DECR("DECR", "降序 1"),
    TOP("TOP", "置顶");

    private String type;
    private String desc;

    SortEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescByType(String type) {
        if (StringUtils.isBlank(type)) {
            return null;
        }
        for (SortEnum sort : SortEnum.values()) {
            if (type.equals(sort.getType())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
