/**
 * @(#)AppRegisterDto.java 1.0 2018/6/26
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 应用注册Dto
 * 用于存放应用注册信息的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
@ApiModel(value = "AppRegisterDto", description = "应用注册")
public class AppRegisterDto extends BaseDto {
    private static final long serialVersionUID = -4123726866859296744L;

    @ApiModelProperty(value = "应用模板id")
    private Long id;

    /**
     * 应用代码
     */
    @ApiModelProperty(value = "应用代码，必填")
    private String code;

    /**
     * 应用名称
     */
    @ApiModelProperty(value = "应用名称，必填")
    @NotNull
    private String name;
    /**
     * 应用类型：1:单租户,2:多租户
     */
    @ApiModelProperty(value = "应用类型：1:单租户,2:多租户，选填")
    private Integer applicationType;

    /**
     * 状态 1启用 2禁用
     */
    @ApiModelProperty(value = "状态 1启用 2禁用，新增选填，修改必填，默认1启用")
    private Integer status;
    /**
     * 应用所属用户id
     */
    @ApiModelProperty(value = "应用所属用户id，必填")
    private Long ownerId;
    /**
     * 开发者名称
     */
    @ApiModelProperty(value = "开发者名称，选填")
    private String developer;
    /**
     * 开发者手机号码
     */
    @ApiModelProperty(value = "开发者手机号码，选填")
    private String developerPhone;
    /**
     * 开发者邮箱
     */
    @ApiModelProperty(value = "开发者邮箱，选填")
    private String developerEamil;
    /**
     * 角色模板列表，选填
     */
    @ApiModelProperty(value = "角色模板列表，修改操作是重新赋值，选填")
    private List<RoleTemplateDto> roleTemplateDtos;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getApplicationType() {
        return applicationType;
    }

    public void setApplicationType(Integer applicationType) {
        this.applicationType = applicationType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getDeveloper() {
        return developer;
    }

    public void setDeveloper(String developer) {
        this.developer = developer;
    }

    public String getDeveloperPhone() {
        return developerPhone;
    }

    public void setDeveloperPhone(String developerPhone) {
        this.developerPhone = developerPhone;
    }

    public String getDeveloperEamil() {
        return developerEamil;
    }

    public void setDeveloperEamil(String developerEamil) {
        this.developerEamil = developerEamil;
    }

    public List<RoleTemplateDto> getRoleTemplateDtos() {
        return roleTemplateDtos;
    }

    public void setRoleTemplateDtos(List<RoleTemplateDto> roleTemplateDtos) {
        this.roleTemplateDtos = roleTemplateDtos;
    }
}
