/**
 * @(#)LinkmanInfoDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 联系人信息Dto
 * 用于存放,查询等联系人信息的数据传输对象
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ContactsInfoDto", description = "联系人信息")
public class ContactsInfoDto extends BaseDto {
    private static final long serialVersionUID = -5689205554163109684L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    /**
     * 联系人手机号
     */
    @NotNull(message = "联系人手机号不能为null")
    @ApiModelProperty(value = "联系人手机号，必填")
    private String phoneNum;

    /**
     * 联系人座机号
     */
    @ApiModelProperty(value = "联系人座机号，选填", allowEmptyValue = true)
    private String tel;

    /**
     * 联系人姓名
     */
    @NotNull(message = "联系人姓名不能为null")
    @ApiModelProperty(value = "联系人姓名，必填")
    private String linkName;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名，选填")
    private String username;

    /**
     * 证件类型
     */
    @ApiModelProperty(value = "证件类型，选填")
    private String identityType;


    /**
     * 身份证证件号码
     */
    //@Pattern(regexp = VerifyUtil.REGEX_ID_CARD, message = "身份证号码格式不正确")
    @ApiModelProperty(value = "身份证证件号码，选填")
    private String idCardNum;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址，选填", allowEmptyValue = true)
    private String address;


    /**
     * 省编号
     */
    @ApiModelProperty(value = "省编号，选填")
    private String provinceCode;

    /**
     * 市编号
     */
    @ApiModelProperty(value = "市编号，选填")
    private String cityCode;

    /**
     * 区编号
     */
    @ApiModelProperty(value = "区编号，选填")
    private String districtCode;

    /**
     * 街道编号
     */
    @ApiModelProperty(value = "街道编号，选填")
    private String streetCode;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编，选填")
    private String postcode;

    /**
     * 所在省名称
     */
    @ApiModelProperty(value = "所在省名称，选填")
    private String province;

    /**
     * 所在市名称
     */
    @ApiModelProperty(value = "所在市名称，选填")
    private String city;

    /**
     * 所在区名称
     */
    @ApiModelProperty(value = "所在区名称，选填")
    private String district;

    /**
     * 是否默认联系人
     * 0 不是  1 是
     */
    @NotNull(message = "请填写默认联系人状态")
    @ApiModelProperty(value = "是否默认联系人: 0 不是  1 是，必填")
    private Integer status;

    /**
     * 职位
     */
    @ApiModelProperty(name = "position ", value = "职位")
    private String position;

    /**
     * 预留手机
     */
    @ApiModelProperty(name = "reserveMobile ", value = "预留手机")
    private String reserveMobile;

    /**
     * 组织信息Id
     */
    @ApiModelProperty(name = "orgInfoId ", value = "组织信息Id")
    private Long orgInfoId;

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getReserveMobile() {
        return reserveMobile;
    }

    public void setReserveMobile(String reserveMobile) {
        this.reserveMobile = reserveMobile;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIdCardNum() {
        return idCardNum;
    }

    public void setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }
}
