/**
 * @(#) RoleDto.java 1.0 2018-06-15
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 角色Dto
 * 用于分配角色,角色描述,角色状态等数据 传输对象
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "RoleDto", description = "角色")
public class RoleDto extends BaseDto {
    private static final long serialVersionUID = -4122202377515721309L;
    @ApiModelProperty(name = "id")
    private Long id;
    /**
     * 角色编号
     */
    @ApiModelProperty("角色编号，必填")
    @NotNull
    private String code;
    /**
     * 角色名称
     */
    @ApiModelProperty("角色名称，必填")
    @NotNull
    private String name;
    /**
     * 状态：1启用2禁用
     */
    @ApiModelProperty(name = "状态：1启用2禁用，默认1启用")
    private Integer status;
    /**
     * 角色描述
     */
    @ApiModelProperty("角色描述，选填")
    private String description;

    /**
     * 用户ID
     */
    @ApiModelProperty(name = "用户ID，选填")
    private Long ownerId;

    /**
     * 父结点ID
     */
    @ApiModelProperty(name = "父结点ID，选填")
    private Long parentId;

    @ApiModelProperty(name = "组织ID")
    private Long belongOrgId;

    /**
     * 关联用户个数
     */
    @ApiModelProperty(value = "关联用户个数")
    private Integer userRelationNum;

    /**
     * 关联用户组个数
     */
    @ApiModelProperty(value = "关联用户组个数")
    private Integer userGroupRelationNum;

    /**
     * 引用角色id
     */
    @ApiModelProperty(name = "引用角色id")
    private Long refRoleId;

    @ApiModelProperty(name = "角色类型，1：标准角色，2:自定义")
    private Integer roleType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getBelongOrgId() {
        return belongOrgId;
    }

    public RoleDto setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
        return this;
    }

    public Integer getUserRelationNum() {
        return userRelationNum;
    }

    public void setUserRelationNum(Integer userRelationNum) {
        this.userRelationNum = userRelationNum;
    }

    public Integer getUserGroupRelationNum() {
        return userGroupRelationNum;
    }

    public void setUserGroupRelationNum(Integer userGroupRelationNum) {
        this.userGroupRelationNum = userGroupRelationNum;
    }

    public Long getRefRoleId() {
        return refRoleId;
    }

    public void setRefRoleId(Long refRoleId) {
        this.refRoleId = refRoleId;
    }

    public Integer getRoleType() {
        return roleType;
    }

    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }
}
