/**
 * @(#)UserGroupDto.java 1.0 June 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户组Dto
 * 用于用户组存放的数据传输对象
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "UserGroupDto", description = "用户组")
public class UserGroupDto extends BaseDto {
    private static final long serialVersionUID = -7060763007063577776L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "创建者Id")
    private Long ownerId;

    @ApiModelProperty(value = "父id: 为null则是根节点")
    private Long parentId;

    @ApiModelProperty(value = "组类型, 1 用户组, 2 通知组")
    private Integer groupType;

    @NotNull(message = "用户组名称不能为null")
    @ApiModelProperty(value = "用户组名称, 必填")
    private String groupName;

    @ApiModelProperty(value = "用户组备注, 选填")
    private String remark;

    /**
     * 用户组状态
     * 0 禁用  1 启用
     */
    @ApiModelProperty(value = "用户组状态 0 禁用, 1 启用, 选填", allowEmptyValue = true)
    private Integer status;

    @ApiModelProperty(value = "子用户组")
    private List<UserGroupDto> children;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public List<UserGroupDto> getChildren() {
        return children;
    }

    public void setChildren(List<UserGroupDto> children) {
        this.children = children;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getGroupType() {
        return groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
