package com.dtyunxi.yundt.cube.center.user.api.dto.boc.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @author qingzhu
 * @since 2.0.0
 */
@ApiModel(value = "UserModifyReqDto", description = "编辑用户请求dto")
public class UserModifyReqDto extends BaseVo {

    @NotNull
    @ApiModelProperty(value = "用户id")
    private Long id;

    @ApiModelProperty(value = "用户名/登录名")
    private String userName;

    @ApiModelProperty(value = "姓名/昵称")
    private String nickName;

    @ApiModelProperty(value = "passWord", notes = "密码")
    private String passWord;

    @ApiModelProperty(value = "phone", notes = "手机号")
    private String phone;

    @Email
    @ApiModelProperty(value = "email", notes = "邮箱")
    private String email;

    @ApiModelProperty(value = "brief", notes = "备注")
    private String brief;


    @ApiModelProperty(value = "角色编码列表，选填")
    private List<String> roleCodes = new ArrayList<>();

    @ApiModelProperty(value = "giveRolesReqDtoList", notes = "角色idList和所属实例id")
    private List<GiveRolesReqDto> giveRolesReqDtoList;


    @ApiModelProperty(value = "应用id列表,选填")
    private List<Long> instanceIds;

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<String> getRoleCodes() {
        return roleCodes;
    }

    public void setRoleCodes(List<String> roleCodes) {
        this.roleCodes = roleCodes;
    }

    public List<GiveRolesReqDto> getGiveRolesReqDtoList() {
        return giveRolesReqDtoList;
    }

    public void setGiveRolesReqDtoList(List<GiveRolesReqDto> giveRolesReqDtoList) {
        this.giveRolesReqDtoList = giveRolesReqDtoList;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public List<Long> getInstanceIds() {
        return instanceIds;
    }

    public void setInstanceIds(List<Long> instanceIds) {
        this.instanceIds = instanceIds;
    }
}
