package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * API请求dto
 *
 * @author 代码生成器
 */
@ApiModel(value = "ApiReqDto", description = "API请求dto")
public class ApiReqDto extends BaseVo {

    /**
     *  API名称
     */
    @NotNull(message = "API名称不能为空")
    @ApiModelProperty(value = "API名称")
    private String apiName;
    /**
     *  应用编码
     */
    @NotNull(message = "应用编码不能为空")
    @ApiModelProperty(value = "应用编码")
    private String module;
    /**
     *  API路径
     */
    @NotNull(message = "API路径不能为空")
    @ApiModelProperty(value = "API路径")
    private String path;
    /**
     *  请求方式
     */
    @NotNull(message = "请求方式不能为空")
    @ApiModelProperty(value = "请求方式")
    private String method;
    /**
     *  调用类方法
     */
    @ApiModelProperty(value = "调用类方法")
    private String invokeMethod;
    /**
     *  是否需要鉴权：0=否、1=是
     */
    @NotNull(message = "请选择是否需要鉴权")
    @ApiModelProperty(value = "是否需要鉴权：0=否、1=是")
    private Integer needAuthored;
    /**
     *  资源编码
     */
    @ApiModelProperty(value = "资源编码集合")
    private List<String> resourceCodes;

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getInvokeMethod() {
        return invokeMethod;
    }

    public void setInvokeMethod(String invokeMethod) {
        this.invokeMethod = invokeMethod;
    }

    public Integer getNeedAuthored() {
        return needAuthored;
    }

    public void setNeedAuthored(Integer needAuthored) {
        this.needAuthored = needAuthored;
    }

    public List<String> getResourceCodes() {
        return resourceCodes;
    }

    public void setResourceCodes(List<String> resourceCodes) {
        this.resourceCodes = resourceCodes;
    }
}