package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Set;

public class AppInstanceCreateReqDto extends BaseVo {
    /**
     * 应用编码
     */
    @NotNull(message = "应用编码不能为null")
    @Pattern(regexp = "^[\\w\\-\\.]{1,200}$", message = "应用编码只能为字母，中划线下划线,点号，数字组合且长度不能超过200个字符")
    @ApiModelProperty(value = "应用编码")
    private String code;
    /**
     * 应用模板编码
     */
    @ApiModelProperty(value = "应用模板编码")
    private String appCode;

    /**
     * 应用模板id
     */
    @ApiModelProperty(value = "应用模板id")
    private Long appId;

    /**
     * 访问入口
     */
    @ApiModelProperty(value = "访问入口，必填,url格式.可以省略协议部分", required = true)
    @NotNull(message = "访问入口不能为null")
    private String hostName;

    /**
     * 域名入口
     */
    @ApiModelProperty(value = "域名入口")
    private String serverName;

    /**
     * 应用名称
     */
    @NotNull(message = "应用名称不能为空")
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{1,50}$", message = "应用名称只能为字母，下划线，数字，中文组合且长度不能超过50个字符")
    @ApiModelProperty(value = "应用名称，必填", required = true)
    private String appInsName;

    @ApiModelProperty(value = "租户id，必填", required = true)
    @NotNull(message = "租户id不能为空")
    private Long tenantId;


    /**
     * 归属的业务空间code
     */
    @ApiModelProperty(value = "归属的业务空间code,0或不填表示直接归属到租户")
    private String bizSpaceCode;

    @ApiModelProperty(value = "数据初始化状态,由应用自己决定具体内容")
    private String dataInitStatus;

    @ApiModelProperty(value = "应用默认账号域设置，选填，不填且trustDomain值为null则默认值为default")
    private String defDomain;

    @ApiModelProperty(value = "默认之外, 应用其他支持的账号域, ")
    private Set<String> trustDomain;

    /**
     * 应用logo
     */
    @ApiModelProperty(value = "应用logo ")
    private String logoUrl;

    /**
     * 应用描述
     */
    @ApiModelProperty(value = "应用描述 ")
    private String description;

    /**
     * 应用状态
     */
    @ApiModelProperty(value = "应用状态 ")
    private Integer status;

    /**
     * 应用接入BOC方式，1嵌入BOC，2跳转新页面
     */
    @ApiModelProperty(value = "应用接入BOC方式，1嵌入BOC，2跳转新页面")
    private Integer jumpType = 1;

    /**
     * 足迹页签，0不需要，1需要
     */
    @ApiModelProperty(value = "足迹页签，0不需要，1需要")
    private Integer footTable;

    /**
     * 应用渠道，1自建应用，2第三方应用，3合作应用
     */
    @ApiModelProperty(value = "应用渠道，1自建应用，2第三方应用，3合作应用")
    private Integer instanceChannel = 1;

    /**
     * 业务类型，1toB，2toC
     */
    @ApiModelProperty(value = "业务类型，1toB，2toC")
    private Integer businessType = 1;

    /**
     * 终端类型，1PC，2手机
     */
    @ApiModelProperty(value = "终端类型，1PC，2手机")
    private Integer terminalType = 1;

    /**
     * 账号，对应基础数据中心表channel_account字段account，第三方应用才有值
     */
    @ApiModelProperty(value = "账号，对应基础数据中心表channel_account字段account，第三方应用才有值")
    private String account;

    /**
     * 账号类型，[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]
     */
    @ApiModelProperty(value = "账号类型，[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]")
    private Integer accountType;

    /**
     * 应用配置信息，json存储格式，第三方应用才有值
     */
    @ApiModelProperty(value = "应用配置信息，json存储格式[例如微信的渠道配置例子：{\"appId\": \"APPID\",\"appSecret\": \"APPSECRET\"}]，第三方应用才有值")
    private String instanceConfig;

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getAppInsName() {
        return appInsName;
    }

    public void setAppInsName(String appInsName) {
        this.appInsName = appInsName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public String getDataInitStatus() {
        return dataInitStatus;
    }

    public void setDataInitStatus(String dataInitStatus) {
        this.dataInitStatus = dataInitStatus;
    }

    public String getDefDomain() {
        return defDomain;
    }

    public void setDefDomain(String defDomain) {
        this.defDomain = defDomain;
    }

    public Set<String> getTrustDomain() {
        return trustDomain;
    }

    public void setTrustDomain(Set<String> trustDomain) {
        this.trustDomain = trustDomain;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getJumpType() {
        return jumpType;
    }

    public void setJumpType(Integer jumpType) {
        this.jumpType = jumpType;
    }

    public Integer getFootTable() {
        return footTable;
    }

    public void setFootTable(Integer footTable) {
        this.footTable = footTable;
    }

    public Integer getInstanceChannel() {
        return instanceChannel;
    }

    public void setInstanceChannel(Integer instanceChannel) {
        this.instanceChannel = instanceChannel;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getInstanceConfig() {
        return instanceConfig;
    }

    public void setInstanceConfig(String instanceConfig) {
        this.instanceConfig = instanceConfig;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }
}
