package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("应用批量查询请求")
public class AppInstanceQueryReqDto extends BaseVo {
    @ApiModelProperty(value = "应用id")
    private Long id;
    @ApiModelProperty(value = "应用所属的业务空间的编码")
    private String bizSpaceCode;
    @ApiModelProperty(value = "应用代码")
    private String appInsCode;
    @ApiModelProperty(value = "应用所属的应用模板代码")
    private String appCode;
    @ApiModelProperty(value = "应用状态：1，启用；2，禁用")
    private Integer status;

    @ApiModelProperty(value = "租户id,仅平台应用可指定, 否则会使用被请求的应用所在的租户")
    private Long queryTenantId;

    @ApiModelProperty(value = "是否包含租户级的应用,如BOC,默认不包含")
    private boolean includeTenantApp;

    /**
     * 账号，对应基础数据中心表channel_account字段account，第三方应用才有值
     */
    @ApiModelProperty(value = "账号，对应基础数据中心表channel_account字段account，第三方应用才有值")
    private String account;

    public Long getId() {
        return id;
    }

    public AppInstanceQueryReqDto setId(Long id) {
        this.id = id;
        return this;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public AppInstanceQueryReqDto setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
        return this;
    }

    public String getAppInsCode() {
        return appInsCode;
    }

    public AppInstanceQueryReqDto setAppInsCode(String appInsCode) {
        this.appInsCode = appInsCode;
        return this;
    }

    public String getAppCode() {
        return appCode;
    }

    public AppInstanceQueryReqDto setAppCode(String appCode) {
        this.appCode = appCode;
        return this;
    }

    public Integer getStatus() {
        return status;
    }

    public AppInstanceQueryReqDto setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public boolean isIncludeTenantApp() {
        return includeTenantApp;
    }

    public AppInstanceQueryReqDto setIncludeTenantApp(boolean includeTenantApp) {
        this.includeTenantApp = includeTenantApp;
        return this;
    }

    public Long getQueryTenantId() {
        return queryTenantId;
    }

    public AppInstanceQueryReqDto setQueryTenantId(Long queryTenantId) {
        this.queryTenantId = queryTenantId;
        return this;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }
}
