package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "DeviceReqDto", description = "设备dto")
public class DeviceReqDto extends BaseDto {
    private static final long serialVersionUID = 9135275412471059311L;

    @NotNull
    @ApiModelProperty(value = "设备id，必填")
    private String deviceId;

    @ApiModelProperty(value = "设备地点，选填")
    private String location;

    @ApiModelProperty(value = "设备IP，选填")
    private String ip;

    @ApiModelProperty(value = "操作系统版本，选填")
    private String osVersion;

    @ApiModelProperty(value = "联系电话，选填")
    private String phone;

    @ApiModelProperty(value = "用户id，选填")
    private Long userId;

    @ApiModelProperty(value = "扩展信息，选填")
    private String extension;

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }
}
