package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 *
 */

/**
 * @Description: 资源注册请求dto
 * @Author: 水镜
 * @Date: 2020/9/11 16:30
 * @Version: 0.1.0
 */
@ApiModel(value = "ResourceRegisterReqDto", description = "资源注册请求dto")
public class ResourceRegisterDto extends RequestDto {

    /**
     * 前端应用编码
     */
    @NotNull(message = "前端应用编码不能为空")
    @ApiModelProperty(name = "appCode", value = "应用编码")
    private String appCode;

    /**
     * 资源来源：1=静态资源 2=动态资源
     */
    @NotNull(message = "资源来源不能为空")
    @ApiModelProperty(value = "资源来源类型：1=静态资源 2=动态资源")
    private Integer source;

    /**
     * 资源集合
     */
    private List<ResourceDto> resources;


    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public List<ResourceDto> getResources() {
        return resources;
    }

    public void setResources(List<ResourceDto> resources) {
        this.resources = resources;
    }
}