/**
 * @(#) ThirdPartyUserReqDto.java 1.0 2018-11-29
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BindingsDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;

/**
 * 第三方授权账号
 *
 * @author 刘备
 * @since 1.0.0
 */
@ApiModel(value = "ThirdPartyUserReqDto", description = "第三方授权账号")
public class ThirdPartyUserReqDto extends BaseDto {

    @ApiModelProperty(value = "用户")
    @Valid
    private UserDto userDto;

    @ApiModelProperty(value = "绑定信息")
    @Valid
    private BindingsDto bindingsDto;

    public UserDto getUserDto() {
        return userDto;
    }

    public void setUserDto(UserDto userDto) {
        this.userDto = userDto;
    }

    public BindingsDto getBindingsDto() {
        return bindingsDto;
    }

    public void setBindingsDto(BindingsDto bindingsDto) {
        this.bindingsDto = bindingsDto;
    }
}