/**
 * @(#) UserOrgRelationQueryReqDto.java 1.0 2020-02-24
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "UserOrgRelationQueryReqDto", description = "用户组织关联查询请求Dto")
public class UserOrgRelationQueryReqDto extends BaseDto {

    @ApiModelProperty(value = "组织id,必填")
    @NotNull
    private Long orgId;

    @ApiModelProperty(value = "用户名,选填")
    private String userName;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }
}
