/*
 * @(#)AppInstanceUserQueryReq.java 1.0 19.12.19
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request.application;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel("用户应用资源查询请求")
public class AppInstanceUserQueryReqDto extends BaseVo {
    @NotNull(message = "用户Id不能为空")
    @ApiModelProperty(value = "用户Id",required = true)
    private Long userId;

    @NotEmpty(message = "res不能为空")
    @ApiModelProperty(value = "buttons,menus或者buttons或者menus，表示查询按钮和菜单信息", required = true)
    private List<String> res;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public List<String> getRes() {
        return res;
    }

    public void setRes(List<String> res) {
        this.res = res;
    }
}
