/**
 * @(#)AccessTemplateRespDto 1.0 2019/11/1
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author shuangqing  2019/11/1
 */
@ApiModel(value = "AccessTemplateRespDto", description = "权限模板返回Dto")
public class AccessTemplateRespDto extends BaseDto {
    /**
     * 权限模板code
     */
    @ApiModelProperty(value = "code", name = "权限模板code")
    private String code;

    /**
     * 资源code
     */
    @ApiModelProperty("资源code")
    private String resourceCode;

    /**
     * 权限属性(按位操作) 1:查询,2:编辑,4:删除,8:创建 多选则累加起来
     */
    @ApiModelProperty("权限属性(按位操作) 1:查询,2:编辑,4:删除,8:创建 多选则累加起来")
    private Integer permissions;

    /**
     * 资源类型
     */
    @ApiModelProperty("资源类型")
    private Integer resourceType;

    /**
     * 资源详情
     */
    @ApiModelProperty("资源详情")
    private ResourceQueryResDto resourceQueryResDto;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public Integer getPermissions() {
        return permissions;
    }

    public void setPermissions(Integer permissions) {
        this.permissions = permissions;
    }

    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceQueryResDto getResourceQueryResDto() {
        return resourceQueryResDto;
    }

    public void setResourceQueryResDto(ResourceQueryResDto resourceQueryResDto) {
        this.resourceQueryResDto = resourceQueryResDto;
    }
}
