/**
 * @(#)UserVo.java 1.0 2018/7/4
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.vo;


import com.dtyunxi.yundt.cube.center.user.api.dto.*;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author 南枫
 * @since 1.0.0
 */
public class UserVo extends BaseDto {

    private static final long serialVersionUID = -5324816712440464348L;

    @ApiModelProperty(name = "id")
    private Long id;
    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码")
    private String password;

    /**
     * 1启用2禁用
     */
    @ApiModelProperty(value = "1启用2禁用")
    private Integer status;

    /**
     * 激活状态
     * 0.未激活 1.已激活
     */
    @ApiModelProperty(value = "激活状态,0.未激活 1.已激活")
    private Integer activeState;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称")
    private String nickName;

    /**
     * 头像
     */
    @ApiModelProperty(value = "头像")
    private String avatar;

    /**
     * 有效起始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效起始时间")
    private Date validStartDate;

    /**
     * 有效结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效结束时间")
    private Date validEndDate;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 用户分类
     */
    @ApiModelProperty(value = "用户分类")
    private Integer userType;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    /**
     * 邀请码
     */
    @ApiModelProperty(value = "邀请码")
    private String inviteCode;

    @ApiModelProperty(value = "扩展属性")
    private String extension;

    /**
     * 地址信息
     */
    @ApiModelProperty(value = "地址信息")
    private List<AddressDto> addressList = new ArrayList<>();

    /**
     * 发票信息
     */
    @ApiModelProperty(value = "发票信息")
    private List<BillInfoDto> billInfoList = new ArrayList<>();

    /**
     * 个人信息
     */
    @ApiModelProperty(value = "个人信息")
    private PersonalInfoDto personalInfo;

    /**
     * 组织信息
     */
    //@ApiModelProperty(value = "组织信息")
    //private OrganizationInfoDto organizationInfo;

    /**
     * 角色列表
     */
    @ApiModelProperty(value = "角色列表")
    private Set<RoleDto> roleSet = Sets.newHashSet();

    /**
     * 员工信息
     */
    //@ApiModelProperty(value = "员工信息列表")
    //private List<EmployeeDto> employeeList;

    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间")
    private Date registerTime;

    /**
     * 个人简介
     */
    @ApiModelProperty(value = "个人简介")
    private String brief;

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(String inviteCode) {
        this.inviteCode = inviteCode;
    }

    public List<AddressDto> getAddressList() {
        return addressList;
    }

    public void setAddressList(List<AddressDto> addressList) {
        this.addressList = addressList;
    }

    public List<BillInfoDto> getBillInfoList() {
        return billInfoList;
    }

    public void setBillInfoList(List<BillInfoDto> billInfoList) {
        this.billInfoList = billInfoList;
    }

    public Set<RoleDto> getRoleSet() {
        return roleSet;
    }

    public void setRoleSet(Set<RoleDto> roleSet) {
        this.roleSet = roleSet;
    }
/*

    public OrganizationInfoDto getOrganizationInfo() {
        return organizationInfo;
    }

    public void setOrganizationInfo(OrganizationInfoDto organizationInfo) {
        this.organizationInfo = organizationInfo;
    }
*/

    public PersonalInfoDto getPersonalInfo() {
        return personalInfo;
    }

    public void setPersonalInfo(PersonalInfoDto personalInfo) {
        this.personalInfo = personalInfo;
    }

    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Integer getActiveState() {
        return activeState;
    }

    public void setActiveState(Integer activeState) {
        this.activeState = activeState;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }
    /*(功能包分离删除API)
    public List<EmployeeDto> getEmployeeList() {
        return employeeList;
    }

    public UserVo setEmployeeList(List<EmployeeDto> employeeList) {
        this.employeeList = employeeList;
        return this;
    }*/

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }
}

