package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.starter.api.auth.IApiValidateApi;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ApiReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ApiQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * API查询接口
 *
 * @author 代码生成器
 */
@Api(tags = {"用户中心：API查询接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-query-IApiQueryApi",path = "/v1/api", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IApiQueryApi extends IApiValidateApi {

    /**
     * 根据id查询API
     *
     * @param id APIid
     * @return API数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询API", notes = "根据id查询API")
    @Capability(capabilityCode = "user.api.query-by-id")
    RestResponse<ApiQueryRespDto> queryById(@PathVariable("id") Long id);

    /**
     * API分页数据
     *
     * @param reqDto             API查询条件
     * @param pageNum            当前页
     * @param pageSize           页大小
     * @return API分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "API分页数据", notes = "API分页数据")
    @Capability(capabilityCode = "user.api.query-by-page")
    RestResponse<PageInfo<ApiQueryRespDto>> queryByPage(@SpringQueryMap ApiReqDto reqDto,
                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
