/**
 * @(#) IUserExtQueryApi.java 1.1.0 2018-06-13 Copyright (c) 2018, YUNXI. All rights reserved. YUNXI
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserMgmtDetailDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


/**
 * 用户账户查询API接口
 *
 * @author 吉米
 * @since 1.0.0
 */
@Api(tags = {"用户中心：用户账户扩展查询服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-query-IUserExtQueryApi",path = "/v1/user", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IUserExtQueryApi {

    /**
     * 查询用户列表
     *
     * @param orgId    组织ID
     * @param userName 用户名
     * @param status   状态
     * @param phone    手机号码
     * @param realName 真实姓名
     * @param userType 用户类型
     * @param filter   tenantId, instanceId,domain通过filter传递
     * @param pageNum  起始页
     * @param pageSize 每一页的记录数
     * @return PageInfo
     */
    @ApiOperation(value = "查询用户列表", notes = "查询用户列表,tenantId, instanceId,domain通过filter传递")
    @RequestMapping(value = {"/org/{orgId}"}, method = RequestMethod.GET)
    @Capability(capabilityCode = "user.user-ext.find-user-list")
    RestResponse<PageInfo<Map<String, Object>>> findUserList(@PathVariable("orgId") Long orgId,
                                                             @RequestParam(name = "userName", required = false) String userName,
                                                             @RequestParam(name = "status", required = false) Integer status,
                                                             @RequestParam(name = "phone", required = false) String phone,
                                                             @RequestParam(name = "realName", required = false) String realName,
                                                             @RequestParam(name = "userType", required = false) String userType,
                                                             @RequestParam("filter") String filter,
                                                             @RequestParam("pageNum") Integer pageNum,
                                                             @RequestParam("pageSize") Integer pageSize);

    /**
     * 查询用户列表
     * @param filter 查询条件
     * @param pageSize
     * @return
     */
//    @ApiOperation(value = "查询用户列表", notes = "查询用户列表")
    //  @RequestMapping(value = {"/org/{orgId}"}, method = RequestMethod.GET)
    /*RestResponse<PageInfo<Map<String, Object>>> queryUsers(@RequestParam("filter") UserQueryFilter filter,
                                                             @RequestParam("pageSize") Integer pageSize);*/


    /**
     * 查询用户详细信息列表
     *
     * @param orgId    组织ID
     * @param userName 用户名
     * @param status   状态
     * @param phone    手机号码
     * @param realName 真实姓名
     * @param userType 用户类型
     * @param filter   tenantId, instanceId,domain通过filter传递
     * @param pageNum  起始页
     * @param pageSize 每一页的记录数
     * @return PageInfo
     */
    @ApiOperation(value = "查询用户详细信息列表", notes = "查询用户详细信息列表" +
            "【2019-03-19新增支持】filter格式：增加支持批次号batch查询数据，目前只支持eq操作 ，{ \t\"filters\": [\n{ \t\t\"property\": \"batch\", \n\t\t\"operator\": \"eq\", \n\t\t\"value\": \"155261961453100\" \n\t}] },domain通过filter传递")
    @RequestMapping(value = {"/org/{orgId}/info"}, method = RequestMethod.GET)
    @Capability(capabilityCode = "user.user-ext.find-user-info-list")
    RestResponse<PageInfo<Map<String, Object>>> findUserInfoList(@PathVariable("orgId") Long orgId,
                                                                 @RequestParam(name = "userName", required = false) String userName,
                                                                 @RequestParam(name = "status", required = false) Integer status,
                                                                 @RequestParam(name = "phone", required = false) String phone,
                                                                 @RequestParam(name = "realName", required = false) String realName,
                                                                 @RequestParam(name = "userType", required = false) String userType,
                                                                 @RequestParam("filter") String filter,
                                                                 @RequestParam("pageNum") Integer pageNum,
                                                                 @RequestParam("pageSize") Integer pageSize);

    @Deprecated
    @ApiOperation(value = "查询用户详细信息列表",notes = "使用/v1/user/organization/employee 接口代替")
    @RequestMapping(value = "/mgmt/list", method = RequestMethod.GET)
    @Capability(capabilityCode = "user.user-ext.find-mgmt-user-list")
    RestResponse<PageInfo<Map<String, Object>>> findMgmtUserList(@RequestParam(name = "userName", required = false) String userName,
                                                                 @RequestParam(name = "status", required = false) Integer status,
                                                                 @RequestParam(name = "realName", required = false) String realName,
                                                                 @RequestParam(name = "orgId", required = false) Long orgId,
                                                                 @RequestParam(name = "orgName", required = false) String orgName,
                                                                 @RequestParam(name = "position", required = false) String position,
                                                                 @RequestParam(name = "instanceId", required = false) Long instanceId,
                                                                 @RequestParam(name = "pageNum") Integer pageNum,
                                                                 @RequestParam(name = "pageSize") Integer pageSize);


    @ApiOperation(value = "查询用户详细信息列表")
    @RequestMapping(value = "/organization/employee", method = RequestMethod.GET)
    @Capability(capabilityCode = "user.user-ext.find-mgmt-user-list")
    RestResponse<PageInfo<Map<String, Object>>> findMgmtUserList(@SpringQueryMap UserMgmtDetailDto userMgmtDetailDto,
                                                                 @RequestParam(name = "pageNum") Integer pageNum,
                                                                 @RequestParam(name = "pageSize") Integer pageSize);

    /*(功能包分离删除API)
    @ApiOperation(value = "批量查询员工分配的组织")
    @RequestMapping(value = "/findOrgsByEmployees",produces = {"application/json;charset=UTF-8"}, method = RequestMethod.GET)
    @Capability(capabilityCode = "user.user-ext.find-orgs-by-employees")
    RestResponse<List<EmployeeListDto>> findOrgsByEmployees(@RequestParam(name = "employeeIds") String employeeIds);
     */

    /**
     * 通过id查询用户详细信息,包含已删除用户
     *
     * @param id  用户id
     * @param res 表示查询地址信息、个人信息、角色列表、发票信息、组织信息
     * @return UserDto
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "用户id", paramType = "path"),
            @ApiImplicitParam(name = "res", value = "address、personInfo、role、billInfo、organizationInfo，表示查询地址信息、个人信息、角色列表、发票信息、组织信息", dataType = "String[]", paramType = "query" ,required = false)
    })
    @RequestMapping(value = "/{id}/ignore-dr", produces = {"application/json;charset=UTF-8"}, method = RequestMethod.GET)
    @ApiOperation(value = "查询用户详细信息,包含已删除用户", notes = "查询用户信息,包含已删除用户，根据传参res带出相应的资源信息")
    @Capability(capabilityCode = "user.user-ext.query-user-by-id-ignore-dr")
    RestResponse<UserDto> queryUserByUserNames(@PathVariable("id") Long id, @RequestParam(name = "res", required = false) String[] res);

    /**
     * 根据用户名称批量查询用户信息
     * @param userQueryReqDto 请求信息
     * @return
     */
    @PostMapping("/queryUserByUserNames")
    @ApiOperation(value = "根据用户名称批量查询用户信息", notes = "根据用户名称批量查询用户信息")
    RestResponse<List<UserRespDto>> queryUserByUserNames(@RequestBody UserQueryReqDto userQueryReqDto);

}

