/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.user.api.dto.ResourceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.MenuEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.MenuMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class MenuDas
extends AbstractBaseDas<MenuEo, String> {
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_BLOCK = 2;

    public List<MenuEo> findByIds(List<Long> ids) {
        MenuMapper menuMapper = (MenuMapper)this.getMapper();
        return menuMapper.findByIds(ids);
    }

    public MenuEo findRootMenu() {
        MenuMapper menuMapper = (MenuMapper)this.getMapper();
        return menuMapper.findRootMenu();
    }

    public List<MenuEo> findByParentCode(String parentCode) {
        MenuEo menuEo = new MenuEo();
        menuEo.setParentCode(parentCode);
        return this.select((BaseEo)menuEo);
    }

    public Long countByInstanceIdAndParentCode(Long instanceId, String parentCode) {
        MenuMapper menuMapper = (MenuMapper)this.getMapper();
        return menuMapper.countByParentCode(instanceId, parentCode);
    }

    public MenuEo selectByInstanceIdAndCode(Long instanceId, String code) {
        MenuEo select = new MenuEo();
        select.setInstanceId(instanceId);
        select.setCode(code);
        select.setDr(0);
        List list = this.select((BaseEo)select, 1, 2);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new BusinessRuntimeException("\u6570\u636e\u5f02\u5e38:code\u4e3a" + code + "\u7684\u6570\u636e\u6709" + list.size() + "\u6761(\u8d85\u8fc7\u4e00\u6761)");
        }
        return (MenuEo)list.get(0);
    }

    public List<MenuEo> selectByInstanceId(Long instanceId) {
        MenuMapper menuMapper = (MenuMapper)this.getMapper();
        return menuMapper.findByInstanceId(instanceId);
    }

    public static List<MenuQueryResDto> buildTree(String parentCode, List<MenuQueryResDto> menus) {
        ArrayList<MenuQueryResDto> tree = new ArrayList<MenuQueryResDto>();
        for (MenuQueryResDto menu : menus) {
            if (!parentCode.equals(menu.getParentCode())) continue;
            tree.add(menu);
            menu.setChildren(MenuDas.buildTree(menu.getCode(), menus));
        }
        tree.sort(Comparator.comparing(ResourceDto::getSortNo));
        return tree;
    }

    public List<MenuEo> findByParent(Long instanceId, String code) {
        MenuEo menuEo = new MenuEo();
        menuEo.setInstanceId(instanceId);
        menuEo.setParentCode(code);
        return this.select((BaseEo)menuEo);
    }

    public void deleteBatch(List<Long> ids) {
        ids.forEach(e -> this.getMapper().deleteLogicById(MenuEo.class, e));
    }

    public Integer updateParentByInstanceIdAndCodes(String parentCode, List<String> menuCodes) {
        MenuMapper menuMapper = (MenuMapper)this.getMapper();
        return menuMapper.updateParentByInstanceIdAndCodes(parentCode, menuCodes);
    }

    public List<MenuEo> selectByCodes(List<String> codes, Long instanceId) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<MenuEo>();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
        MenuEo menuEo = new MenuEo();
        menuEo.setSqlFilters(sqlFilters);
        menuEo.setInstanceId(instanceId);
        return this.select((BaseEo)menuEo, 1, 5000);
    }
}

