/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.ResourceMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ResourceDas
extends AbstractBaseDas<ResourceEo, String> {
    public static List<ResourceQueryResDto> buildTree(String parentCode, String appCode, List<ResourceQueryResDto> menus) {
        ArrayList<ResourceQueryResDto> tree = new ArrayList<ResourceQueryResDto>();
        for (ResourceQueryResDto menu : menus) {
            if (!parentCode.equals(menu.getParentCode())) continue;
            menu.setAppCode(appCode);
            tree.add(menu);
            menu.setMenus(ResourceDas.buildTree(menu.getCode(), appCode, menus));
        }
        tree.sort(Comparator.comparing(ResourceQueryResDto::getSortNo));
        return tree;
    }

    public ResourceEo selectByCode(String code) {
        if (!org.springframework.util.StringUtils.hasText((String)code)) {
            return null;
        }
        ResourceEo select = new ResourceEo();
        select.setCode(code);
        List list = this.select((BaseEo)select);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        if (list.size() == 1) {
            return (ResourceEo)list.get(0);
        }
        throw new BusinessRuntimeException("\u6570\u636e\u5f02\u5e38:code\u4e3a" + code + "\u7684\u6570\u636e\u6709" + list.size() + "\u6761(\u8d85\u8fc7\u4e00\u6761)");
    }

    public List<ResourceEo> selectByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<ResourceEo>();
        }
        ResourceMapper mapper = (ResourceMapper)this.getMapper();
        return mapper.selectByCodes(codes);
    }

    public List<ResourceEo> selectByCodes(List<String> codes, int type) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<ResourceEo>();
        }
        ResourceEo resourceEo = new ResourceEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
        resourceEo.setType(Integer.valueOf(type));
        resourceEo.setSqlFilters(sqlFilters);
        return this.select((BaseEo)resourceEo);
    }

    public ResourceEo selectByCodeAndType(String code, int type) {
        if (!org.springframework.util.StringUtils.hasText((String)code)) {
            return null;
        }
        ResourceEo select = new ResourceEo();
        select.setCode(code);
        select.setType(Integer.valueOf(type));
        List list = this.select((BaseEo)select);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        if (list.size() == 1) {
            return (ResourceEo)list.get(0);
        }
        throw new BusinessRuntimeException("\u6570\u636e\u5f02\u5e38:code\u4e3a" + code + "\u7684\u6570\u636e\u6709" + list.size() + "\u6761(\u8d85\u8fc7\u4e00\u6761)");
    }
}

