/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.user.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserRoleRelationMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class UserRoleRelationDas
extends AbstractBaseDas<UserRoleRelationEo, String> {
    @Resource
    private UserRoleRelationMapper userRoleRelationMapper;

    public List<Long> queryUserIdsByRoleCode(String roleCode) {
        UserRoleRelationMapper userRoleRelationMapper = (UserRoleRelationMapper)this.getMapper();
        return userRoleRelationMapper.queryUserIdsByRoleCode(roleCode);
    }

    public List<UserRoleRelationEo> selectByRodeCodeList(List<String> rodeCodeList, Long instanceId) {
        return this.userRoleRelationMapper.selectByRodeCodeList(rodeCodeList, instanceId);
    }

    public List<UserRoleRelationEo> selectByRodeIdList(List<Long> rodeIdList) {
        return this.userRoleRelationMapper.selectByRodeIdList(rodeIdList);
    }

    public List<UserEo> selectUserByRoleId(Long roleId) {
        return this.userRoleRelationMapper.selectUserByRoleId(roleId);
    }

    public void deleteByUserId(Long userId) {
        List<UserRoleRelationEo> userRoleRelationEoList = this.userRoleRelationMapper.selectByUserId(userId);
        if (!CollectionUtils.isEmpty(userRoleRelationEoList)) {
            List<Long> userRoleRelationIdList = userRoleRelationEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.userRoleRelationMapper.deleteBatchIds(UserRoleRelationEo.class, userRoleRelationIdList.toArray(new Long[userRoleRelationIdList.size()]));
        }
    }

    public List<UserRoleRelationEo> selectByUserAttrValue(Long userId, Map<String, List<String>> userAttrValueMap, Long instanceId) {
        List list;
        if (userId == null || userAttrValueMap == null) {
            return Lists.newArrayList();
        }
        userAttrValueMap.remove("user_id");
        UserRoleRelationEo queryEo = new UserRoleRelationEo();
        ArrayList filters = Lists.newArrayList();
        if (userAttrValueMap.isEmpty()) {
            queryEo.setUserId(userId);
        } else {
            filters.add(SqlFilter.in((String)"user_id", (Object)(userId + ",-128")));
            userAttrValueMap.forEach((fieldName, fieldValueList) -> {
                String valueStr = "-128";
                if (CollectionUtils.isNotEmpty((Collection)fieldValueList)) {
                    valueStr = valueStr + "," + StringUtils.join((Iterable)fieldValueList, (String)",");
                }
                filters.add(SqlFilter.in((String)fieldName, (Object)valueStr));
            });
        }
        queryEo.setSqlFilters((List)filters);
        if (instanceId != null) {
            queryEo.setInstanceId(instanceId);
        }
        if ((list = this.select((BaseEo)queryEo, 0, 4096)) == null) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<UserRoleRelationEo> selectByRoleIdAndUserIdList(Long roleId, List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return null;
        }
        UserRoleRelationEo queryEo = new UserRoleRelationEo();
        queryEo.setRoleId(roleId);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"user_id", (Object)StringUtils.join(userIdList, (String)",")));
        queryEo.setSqlFilters(sqlFilters);
        return this.select((BaseEo)queryEo);
    }
}

