package com.dtyunxi.yundt.cube.center.channel.api.dto.wechat;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 微信公众号消息模板
 * {
 *      "template_list": [{
 *       "template_id": "iPk5sOIt5X_flOVKn5GrTFpncEYTojx6ddbt8WYoV5s",
 *       "title": "领取奖金提醒",
 *       "primary_industry": "IT科技",
 *       "deputy_industry": "互联网|电子商务",
 *       "content": "{ {result.DATA} }\n\n领奖金额:{ {withdrawMoney.DATA} }\n领奖  时间:    { {withdrawTime.DATA} }\n银行信息:{ {cardInfo.DATA} }\n到账时间:  { {arrivedTime.DATA} }\n{ {remark.DATA} }",
 *       "example": "您已提交领奖申请\n\n领奖金额：xxxx元\n领奖时间：2013-10-10 12:22:22\n银行信息：xx银行(尾号xxxx)\n到账时间：预计xxxxxxx\n\n预计将于xxxx到达您的银行卡"
 *    }]
 * }
 * @author : 萧玄
 * @Date: 16:54 2020/12/9
 */
@ApiModel("微信消息模板响应对象")
public class WechatMsgTemplateDto implements Serializable {

    private static final long serialVersionUID = -6020578919272726057L;

    @ApiModelProperty("微信消息模板ID")
    @JsonProperty("template_id")
    private String templateId;

    @ApiModelProperty("模板标题")
    private String title;

    @ApiModelProperty("模板所属行业的一级行业")
    @JsonProperty("primary_industry")
    private String primaryIndustry;

    @ApiModelProperty("模板内容")
    private String content;

    @ApiModelProperty("模板示例")
    private String example;

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPrimaryIndustry() {
        return primaryIndustry;
    }

    public void setPrimaryIndustry(String primaryIndustry) {
        this.primaryIndustry = primaryIndustry;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getExample() {
        return example;
    }

    public void setExample(String example) {
        this.example = example;
    }
}
