package com.dtyunxi.yundt.cube.center.channel.api.dto.wechat;

import com.dtyunxi.yundt.cube.center.channel.api.dto.IChannelTokenRequestParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 微信获取/刷新token请求参数
 *
 * @author : 萧玄
 * @Date: 17:02 2020/12/9
 */
@ApiModel("获取/刷新微信accessToken请求参数")
public class WechatTokenReqDto implements IChannelTokenRequestParam {

    @ApiModelProperty(name = "第三方用户唯一凭证")
    private String appId;

    @ApiModelProperty(name = "第三方用户唯一凭证密钥")
    private String appSecret;

    private int type;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void initType(int type) {
        this.type = type;
    }

    public int readType() {
        return type;
    }
}
