package com.dtyunxi.yundt.cube.center.channel.api.enums;

/**
 * 渠道账号类型
 * 0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook
 *
 * @author : 萧玄
 * @Date: 15:54 2020/12/9
 */
public enum  ChannelAccountTypeEnum implements IEnum {

    WECHAT_SUBSCRIPTION_ACCOUNT(0,"微信订阅号"),
    WECHAT_SERVICE_ACCOUNT(1,"微信服务号"),
    WECHAT_APPLET_ACCOUNT(2,"微信小程序"),
    TIK_TOK_0(3,"抖音"),
    KUAI_SHOU(4,"快手"),
    TAO_BAO(5,"淘宝"),
    ALI_PAY(6,"支付宝"),
    FACEBOOK(7,"facebook"),
    WECHAT_ENTERPRISE_ACCOUNT(8, "企业微信")
    ;

    private int key;
    private String value;

    ChannelAccountTypeEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    @Override
    public String getValue() {
        return value;
    }
}

