package com.dtyunxi.yundt.cube.center.channel.api.query.raw;

import com.alibaba.fastjson.JSONObject;
import feign.Headers;
import feign.Param;
import feign.RequestLine;

import java.util.Map;


/**
 * 微信 API
 *
 * @author : 萧玄
 * @Date: 17:12 2020/12/9
 */
public interface WechatApi {

    /**
     * 获取 accessToken
     * @author : 萧玄
     * @Date: 17:52 2020/12/9
     *
     * @return 示例：{"access_token":"ACCESS_TOKEN","expires_in":7200}
     */
    @RequestLine("GET /cgi-bin/token?grant_type=client_credential&appid={appId}&secret={appSecret}")
    @Headers({"Content-Type: application/json"})
    Map<String,Object> getAccessToken(@Param("appId") String appId, @Param("appSecret") String appSecret);

    /**
     * 获取 accessToken
     * @author : 萧玄
     * @Date: 17:52 2020/12/9
     *
     * @return 示例：
     * {
     *      "template_list": [{
     *       "template_id": "iPk5sOIt5X_flOVKn5GrTFpncEYTojx6ddbt8WYoV5s",
     *       "title": "领取奖金提醒",
     *       "primary_industry": "IT科技",
     *       "deputy_industry": "互联网|电子商务",
     *       "content": "{ {result.DATA} }\n\n领奖金额:{ {withdrawMoney.DATA} }\n领奖  时间:    { {withdrawTime.DATA} }\n银行信息:{ {cardInfo.DATA} }\n到账时间:  { {arrivedTime.DATA} }\n{ {remark.DATA} }",
     *       "example": "您已提交领奖申请\n\n领奖金额：xxxx元\n领奖时间：2013-10-10 12:22:22\n银行信息：xx银行(尾号xxxx)\n到账时间：预计xxxxxxx\n\n预计将于xxxx到达您的银行卡"
     *    }]
     * }
     */

    @RequestLine("GET /cgi-bin/template/get_all_private_template?access_token={accessToken}")
    @Headers({"Content-Type: application/json"})
    JSONObject getAllMsgTemplates(@Param("accessToken") String accessToken);

    /**
     * 获取 accessToken
     * @author : 萧玄
     * @Date: 17:52 2020/12/9
     *
     * @return 示例：{"access_token":"ACCESS_TOKEN","expires_in":7200}
     */
    @RequestLine("GET /cgi-bin/gettoken?corpid={appId}&corpsecret={appSecret}")
    @Headers({"Content-Type: application/json"})
    Map<String,Object> getEnterpriseWeChatAccessToken(@Param("appId") String appId, @Param("appSecret") String appSecret);

}
